﻿if (!QIHelpDesk.grid)
{
	QIHelpDesk.grid = {};
	QIHelpDesk.grid.options = { rootOptions: null, editType: null, dialogID: null, dialog: null, textBox: null, url: null, height: 0, width: 0, left: -1, top: -1, rowNum: 5, caption: '', sortColumn: null, tableElement: null, pagerElement: null, xmlElement: null, rowIDControl: null, returnColumn: null, incrementalSearch: false, searchColumn: '', buttonType: 'link', detailText: 'Detail', editText: 'Upravit', descText: 'Popis', values: { id: null, value: null } };
	QIHelpDesk.grid.urlParams = null;
}

(function()
{
	var grid = QIHelpDesk.grid;
	

	grid.btnDetail = function(gridOptions, cellValue, data, rowObject)
	{
		return QIHelpDesk.grid.createBtn(gridOptions, data.ICU || data.rowId, data.InternalID, 'ticketDetail', 'detailText', rowObject);
	};

	grid.btnEdit = function(gridOptions, cellValue, data, rowObject)
	{
		return QIHelpDesk.grid.createBtn(gridOptions, data.ICU || data.rowId, data.InternalID, 'editTicket', 'editText', rowObject);
	};

	grid.btnDesc = function(gridOptions, cellValue, data, rowObject)
	{
		return QIHelpDesk.grid.createBtn(gridOptions, data.ICU || data.rowId, data.InternalID, 'newTicketDesc', 'descText', rowObject);
	};

	grid.createBtn = function(gridOptions, rowId, internalId, action, textName, rowObject)
	{
		if ((rowId.substr(rowId.length - 2, 2) === '_0') && (!internalId))
			internalId = "'" + $('InternalID', rowObject).text() + "'";

		if (gridOptions.buttonType === 'link')
			return '<a href="#" class="GridAction ' + action + '" onclick="QIPortalAPI.cancelEvent(event || this); QIHelpDesk.grid.click(\'' + action + '\', \'' + rowId + '\', ' + internalId + '); return false">' + gridOptions[textName] + '</a>';

		return '<input type="button" class="GridAction ' + action + '" value="' + gridOptions[textName] + '" onclick="QIPortalAPI.cancelEvent(event || this); QIHelpDesk.grid.click(\'' + action + '\', \'' + rowId + '\', ' + internalId + '); return false;" />';
	};

	grid.click = function(type, icu, internalID)
	{
		
		let url = window.useShortUrlGlobal
			? QIHelpDesk.urls[type].name + '-' + QIHelpDesk.urls[type].urlid + icu.split("_")[0] + ((internalID) ? '?iid=' + internalID : '')
			: QIHelpDesk.urls[type].name + '-_' + QIHelpDesk.urls[type].urlid + icu + '.aspx' + ((internalID) ? '?iid=' + internalID : '');
		location.href = url
		
	};


	grid.onRowDblClick = function (options, ret) {
		var orgRowID;

		var newValue = ret[options.returnColumn];
		if (options.textBox) {
			QIHelpDesk.jq(options.textBox).val(newValue);
			options.lastValue = newValue;
			options.isModified = false;
			options.rootOptions.values.value = newValue;
			options.F4Value = newValue;

			var lopt = QIHelpDesk.getOptions(options.editType);
			lopt.F4Value = newValue;
		}
		if (options.rowIDControl) {
			orgRowID = jQuery('#' + options.rowIDControl).val();
			jQuery('#' + options.rowIDControl).val(ret["ICU"]);
			options.rootOptions.values.id = ret["ICU"];
		}
		if (options.dialog)
			options.dialog.dialog('close');

		if (ret["ICU"] != orgRowID)
			QIHelpDesk.clearRelatedFields(options);

		if (options.editType == 'Device') {
			var opts = QIHelpDesk.getOptions('Product');
			var val = (opts) ? jQuery('#' + opts.textBox).val() : null;
			if ((val == null) || (val == '')) {
				var dvOpts = QIHelpDesk.getOptions('DeviceVersion');
				if (dvOpts) {
					jQuery('#' + dvOpts.textBox).val('');
					opts.lastValue = '';
					jQuery('#' + dvOpts.rowIDControl).val('');
				}

				if (ret['ProductICU'] != null) {
					if (opts) {
						jQuery('#' + opts.textBox).val(ret['ProductName']);
						opts.lastValue = ret['ProductName'];
						jQuery('#' + opts.rowIDControl).val(ret['ProductICU']);
					}

					opts = QIHelpDesk.getOptions('ProductVersion');
					if (opts) {
						jQuery('#' + opts.textBox).val('');
						opts.lastValue = '';
						jQuery('#' + opts.rowIDControl).val('');
					}
				}
			}
		}

	}
})();